'========================================================================================
'
'  $File$
'
'  Owner: Lin Xia
'
'  $Author$
'
'  $DateTime$
'
'  $Revision$
'
'  $Change$
'
'  Copyright 2006-2008 Adobe Systems Incorporated. All rights reserved.
'  
'  NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance 
'  with the terms of the Adobe license agreement accompanying it.  If you have received
'  this file from a source other than Adobe, then your use, modification, or 
'  distribution of it requires the prior written permission of Adobe.
'
'  DESCRIPTION: VBScript glue code for XML Rules Processing
'
'========================================================================================


Class RuleProcessorObject
	Public ruleSet
	Public ruleProcessor
End Class

Function glueCode_MakeRuleProcessor(idApp, ruleSet, prefixMappingTable)
    '  In VBScript we require the application to be passed in as argument
    '  so that no conflicts occur.

    '  This allows us to handle errors here in the code
    On Error Resume Next

	' Get the condition paths of all the rules.
	Dim pathArray(), pathIndex, rulesProcessor
	
    If Err.number <> 0 Then
        Exit Function
    End If

	ReDim pathArray(UBound ( ruleSet ))

	pathIndex = 0
	
	For Each rule in ruleSet
		pathArray(pathIndex) = rule.xpath	
		pathIndex = pathIndex + 1
	Next

    
    ' the following call can cause an error, in which case 
    ' no rules are processed  
	Set rulesProcessor	= idApp.XMLRuleProcessors.Add ( pathArray, prefixMappingTable )	

    If Err.number <> 0 Then
        glueCode_MakeRuleProcessor = NULL
    Else
        ' In VBScript, use Set to assign object references, but not array, string, etc
        Set glueCode_MakeRuleProcessor = new RuleProcessorObject
        glueCode_MakeRuleProcessor.ruleSet = ruleSet
        Set glueCode_MakeRuleProcessor.ruleProcessor = rulesProcessor
    End If
    
End Function

Sub glueCode_DeleteRuleProcessor(rProcessor) 

	' remove the XMLRuleProcessor object
	rProcessor.ruleProcessor.Delete()
		
	' delete the object itself
	'delete	rProcessor;
End Sub

Sub glueCode_ProcessTree (root, rProcessor)
    '  This allows us to handle errors here in the code
    On Error Resume Next
    
    Set matchData = rProcessor.ruleProcessor.StartProcessingRuleSet(root)
    if Err.number = 0 Then
	    glueCode_ProcessMatchData matchData, rProcessor
	End If
		
	rProcessor.ruleProcessor.EndProcessingRuleSet()

	if Err.number <> 0 Then
        errNumber = Err.number
        errSource = Err.Source
        errDesc = Err.Description
        
        On Error Goto 0
        Err.Raise errNumber, errSource, errDesc 
	End If
End Sub

'
' Process the rule set for the given element. Client code calls
' this Sub to start things off. glueCode_processMatchData calls the
' ApplyAction handler for each rule that matches
'

Sub glueCode_ProcessRuleSet (idApp, root, ruleSet, prefixMappingTable )
    '  In VBScript we require the application to be passed in as argument
    '  so that no conflicts occur.
  
    Dim errNumber, errSource, errDesc
    
  	Set mainRProcessor = glueCode_MakeRuleProcessor (idApp, ruleSet, prefixMappingTable)
  	
    '  This allows us to handle errors here in the code
    On Error Resume Next

    glueCode_ProcessTree root, mainRProcessor
    glueCode_DeleteRuleProcessor mainRProcessor

    If Err.number <> 0 Then
        ' Pass the error on to the caller
        errNumber = Err.number
        errSource = Err.Source
        errDesc = Err.Description
    
        On Error Goto 0
        Err.Raise errNumber, errSource, errDesc 
  	End If

End Sub 


'
' Process the children of the current element. Normally the children
' of the element are traversed after the ApplyAction function is called.
' If a client wants to process the children as part of the handler
' then the implementation of ApplyAction should call glueCode_ProcessChildren.
'

Sub glueCode_ProcessChildren ( rProcessor )	
    '  This allows us to handle errors here in the code
    On Error Resume Next

    Dim errNumber, errSource, errDesc

	Set matchData = rProcessor.ruleProcessor.StartProcessingSubtree()

	If Err.number = 0 Then
    	glueCode_ProcessMatchData matchData, rProcessor
	End If
	
	if Err.number <> 0 Then
	    rProcessor.ruleProcessor.Halt()

	    ' We captured the error here to Halt the rule processor, now we pass it on
        errNumber = Err.number
        errSource = Err.Source
        errDesc = Err.Description
		On Error Goto 0
        Err.Raise errNumber, errSource, errDesc 
	End If
	
End Sub

'
' This tells the rule processor to skip the children for the current element.
'

Sub glueCode_SkipChildren ( rProcessor )
    
	rProcessor.ruleProcessor.SkipChildren()

End Sub

'
' Calls apply action on each matched rule
'

Sub glueCode_ProcessMatchData ( matchData, rProcessor )

    ruleSet = rProcessor.ruleSet
	Do While Not ( matchData Is Nothing )		
		Dim applyMatchedRules, matchRulesLength, matchRulesIndex
		
		matchRulesLength	= UBound ( matchData.matchRules )
		applyMatchedRules	= True
				
		For matchRulesIndex = 0 To matchRulesLength Step 1
			If rProcessor.ruleProcessor.Halted = True Then
				Exit For
			End If

			Set ruleItem = ruleSet(matchData.matchRules(matchRulesIndex))
			
			applyMatchedRules = Not ruleItem.apply ( matchData.element, rProcessor )
			
			If applyMatchedRules = False Then
				Exit For
			End If	
		Next

		Set matchData = rProcessor.ruleProcessor.FindNextMatch()	
	Loop
	
End Sub























'' SIG '' Begin signature block
'' SIG '' MIIhPgYJKoZIhvcNAQcCoIIhLzCCISsCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' Epn+w0J1Mwnma23jQzxWNbMLD+90F6B92LxUdndj30qg
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQCHK5i9aO5k82w+FiDw5C
'' SIG '' dzANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTIw
'' SIG '' MTIxOTAwMDAwMFoXDTIyMTIyMTIzNTk1OVowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKraHbKp
'' SIG '' 7LWhQb1eUijAwzznOPnL0ar6Bh5IyTX0X3Nmx0y/zOPp
'' SIG '' A769ixYCLdufIms+U9xBOpXey6jajunMtomUtqLHkYMN
'' SIG '' DT2jzWOCqLvnwrHjehFxLYwYIt9ymU0VqJHPcIO+0lfA
'' SIG '' s4ZoskzD5OepJsCVjURfwILDS/l51c42dKXqbPmr25vz
'' SIG '' UQBlKIg7JV7JJGj29DQMOeCI9LSY4dAUYsfaEfDx0dcb
'' SIG '' T/oDlUZAH/mGrvFonoqGwLDNNSpWkFauC3ryUlgMJ6if
'' SIG '' JX9iZIrdm6Glo/EvxbsHMzsL2TclgBXoa0mYq4PYgMH1
'' SIG '' 5XYNA9y4x7QNLRmWPpXU+4gnfN0CAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBS5nvze3WzR/65rffm/COInbJUTtzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEALl6DDJXB+ruS0J/n4zd6
'' SIG '' IxqKGcJnnn72tgm50zJjxjqD9f4gMlY5lFA4Dcz9D6ur
'' SIG '' Yc734LqeT9p+oUv2PI4KdFMpSmhdrKLkI8eTK46NHVW8
'' SIG '' U/GZctdsVZR1JvtI1ByrH/DkQS7HTKWwtbyOkKU7lfYK
'' SIG '' HIS+qUso64cM6M2asUym8CdN/3FbwJ9dGJDX9yfMISbX
'' SIG '' oIDfInSnVDD+Z9EnnpsEw9obZwNHaGdd1NJRuPrlwatk
'' SIG '' YdBJuo5kN5/eBMYb95FbK8zZf8e+5FTnEJ0PmxRakjlF
'' SIG '' xh5Zg3CCjiIjr3w/uUkOaa2PjpkNy/vuUYxCuJb53Ca6
'' SIG '' i+n/WMWWjYJLNDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCFAIwghP+AgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAhyuYvWjuZPNsPhYg8OQncw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIHJkAPcNhqYJ
'' SIG '' cH/CSb7XCJgoYOYZBB0vV/Q+nVzNyRtUMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAh393hCYt
'' SIG '' X5w6x06CbMmKFmfzhOeO2Zp0sQ/CbbreAU//ogls3qvv
'' SIG '' lj8QoY+/qDssnVMl7AhZs/ovytL99csuXJCd6TnF0sIG
'' SIG '' qliuq68ntHnLlHI+/I2twbBQefWP1eRBmWydvAHUChrt
'' SIG '' eLOxj8YOEPTGPffJAKprROpIZotDcrzure3El/IXeFp9
'' SIG '' Q1VOJJfgsw86AnsjK9uzU9m6Amvtd7F2bXpavy9m+cZ2
'' SIG '' Nln4cu7YOF3M1mf2RvxPPUj+PK+r3jUYg+/oPeSQnNN3
'' SIG '' /Bp0dL8GJd/UyELU9R/ZD834OrC/TY+PiRklwQDb5JYx
'' SIG '' QA+1VtHqPRK/UBEIhX1fciLI1aGCEbMwghGvBgorBgEE
'' SIG '' AYI3AwMBMYIRnzCCEZsGCSqGSIb3DQEHAqCCEYwwghGI
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQ
'' SIG '' AQSgaQRnMGUCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCA8VBT6+IWyyqgX+1ORceRobDd8Ry1nF2QW
'' SIG '' P/oX2ttxTwIRAL4l+EN4Wr3wJKfwgRSyB4sYDzIwMjIw
'' SIG '' NDE4MTkwMjU1WqCCDXwwggbGMIIErqADAgECAhAKekqI
'' SIG '' nsmZQpAGYzhNhpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJ
'' SIG '' BgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5j
'' SIG '' LjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBS
'' SIG '' U0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcN
'' SIG '' MjIwMzI5MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQsw
'' SIG '' CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIElu
'' SIG '' Yy4xJDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAy
'' SIG '' MDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC
'' SIG '' AgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
'' SIG '' 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFEN
'' SIG '' MQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJxbKFiJgHT
'' SIG '' zsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFqRUIj
'' SIG '' QVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRS
'' SIG '' Xw9Q3tRZLER0wDJHGVvimC6P0Mo//8ZnzzyTlU6E6XYY
'' SIG '' mJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHVGBS3BEXz
'' SIG '' 4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2u
'' SIG '' fyguwp7gC0vICNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5w
'' SIG '' LOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03Sh
'' SIG '' L7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHX
'' SIG '' L537/M2xwafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP
'' SIG '' 6+SxIXuGZ1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiay
'' SIG '' CDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tL
'' SIG '' suK2QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqY
'' SIG '' klHNP8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGjggGL
'' SIG '' MIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
'' SIG '' ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAE
'' SIG '' GTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYDVR0j
'' SIG '' BBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0O
'' SIG '' BBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRT
'' SIG '' MFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
'' SIG '' aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGD
'' SIG '' MIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdp
'' SIG '' Y2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNl
'' SIG '' cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRH
'' SIG '' NFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQw
'' SIG '' DQYJKoZIhvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk
'' SIG '' 9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76T
'' SIG '' Ot4qOVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7f
'' SIG '' IyJs1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJT4LW
'' SIG '' pXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
'' SIG '' y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZb
'' SIG '' NZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEiptucdYL0E
'' SIG '' IhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiLfmSi
'' SIG '' ZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBV
'' SIG '' eNaY/lRtf3GpSBp43UZ3Lht6wDOK+EoojBKoc88t+dMj
'' SIG '' 8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pIallDrl/q
'' SIG '' +A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW0
'' SIG '' 5rUMopml1xVrNQ6F1uAszOAMJLh8UgsemXzvyMjFjFhp
'' SIG '' r6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBFThIcFClYzG/T
'' SIG '' f8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zM
'' SIG '' bbUNrkdjOEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3
'' SIG '' AhMcMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0oZipe
'' SIG '' WzANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjIwMzIzMDAwMDAw
'' SIG '' WhcNMzcwMzIyMjM1OTU5WjBjMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMT
'' SIG '' MkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEy
'' SIG '' NTYgVGltZVN0YW1waW5nIENBMIICIjANBgkqhkiG9w0B
'' SIG '' AQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFVxyUD
'' SIG '' xPKRN6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+kiPNo
'' SIG '' +n3znIkLf50fng8zH1ATCyZzlm34V6gCff1DtITaEfFz
'' SIG '' sbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW1Oco
'' SIG '' LevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8ald6
'' SIG '' 8Dd5n12sy+iEZLRS8nZH92GDGd1ftFQLIWhuNyG7QKxf
'' SIG '' st5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRAp8By
'' SIG '' xbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYnLvWH
'' SIG '' po9OdhVVJnCYJn+gGkcgQ+NDY4B7dW4nJZCYOjgRs/b2
'' SIG '' nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU8lKVEStY
'' SIG '' dEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPVA+C/
'' SIG '' 8KI8ykLcGEh/FDTP0kyr75s9/g64ZCr6dSgkQe1CvwWc
'' SIG '' ZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwjjVj33GHek/45
'' SIG '' wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtbiiKo
'' SIG '' wSYI+RQQEgN9XyO7ZONj4KbhPvbCdLI/Hgl27KtdRnXi
'' SIG '' YKNYCQEoAA6EVO7O6V3IXjASvUaetdN2udIOa5kM0jO0
'' SIG '' zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYBAf8C
'' SIG '' AQAwHQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCPnshv
'' SIG '' MB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/nupiuHA9P
'' SIG '' MA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEF
'' SIG '' BQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUHMAGG
'' SIG '' GGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBBBggrBgEF
'' SIG '' BQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29t
'' SIG '' L0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYDVR0f
'' SIG '' BDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmwwIAYD
'' SIG '' VR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0G
'' SIG '' CSqGSIb3DQEBCwUAA4ICAQB9WY7Ak7ZvmKlEIgF+ZtbY
'' SIG '' IULhsBguEE0TzzBTzr8Y+8dQXeJLKftwig2qKWn8acHP
'' SIG '' HQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExiHQwI
'' SIG '' gqgWvalWzxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6q4XN
'' SIG '' Q1/tYLaqT5Fmniye4Iqs5f2MvGQmh2ySvZ180HAKfO+o
'' SIG '' vHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAngkSu
'' SIG '' mScbqyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDnmPv7
'' SIG '' pp1yr8THwcFqcdnGE4AJxLafzYeHJLtPo0m5d2aR8XKc
'' SIG '' 6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un8WbD
'' SIG '' Qc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4c6um
'' SIG '' AU+9Pzt4rUyt+8SVe+0KXzM5h0F4ejjpnOHdI/0dKNPH
'' SIG '' +ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm8heZ
'' SIG '' Wcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr7ZVB
'' SIG '' tzrVFZgxtGIJDwq9gdkT/r+k0fNX2bwE+oLeMt8EifAA
'' SIG '' zV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8apIUP/JiW
'' SIG '' 9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv27dZ8
'' SIG '' /DGCA3YwggNyAgEBMHcwYzELMAkGA1UEBhMCVVMxFzAV
'' SIG '' BgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
'' SIG '' aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2
'' SIG '' IFRpbWVTdGFtcGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaX
'' SIG '' nTANBglghkgBZQMEAgEFAKCB0TAaBgkqhkiG9w0BCQMx
'' SIG '' DQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTIy
'' SIG '' MDQxODE5MDI1NVowKwYLKoZIhvcNAQkQAgwxHDAaMBgw
'' SIG '' FgQUhQjzhlFcs9MHfba0t8B/G0peQd4wLwYJKoZIhvcN
'' SIG '' AQkEMSIEIL4u8EvcjeqNgt1+VC8nrVgOKdAnxm1ndD4p
'' SIG '' nUCpoDt+MDcGCyqGSIb3DQEJEAIvMSgwJjAkMCIEIJ2m
'' SIG '' kBXDScbBiXhFujWCrXDIj6QpO9tqvpwr0lOSeeY7MA0G
'' SIG '' CSqGSIb3DQEBAQUABIICAEYbLpB4tOURu8Gbbx360ZdW
'' SIG '' t4HUc7Yv+CUZsK0LURsqHCd5Sp6z9JGzjhSTR9dnWaq6
'' SIG '' CH/rgE2tSyaz9EhNZXZIbEMGaDphqoadXy1M8G17VFuM
'' SIG '' f39vFXR9LticY85QeR4M/fojbLS9Z9CwZyZx2qNWeFx/
'' SIG '' zEL7pTdBejS2imONWbGwZXuMWSPZdZx4rTvEz1goXSyN
'' SIG '' hpIm8iRTvF3rPs4lbfMNG61ZGVX7/ikghrI7+nvloeol
'' SIG '' Ls/DzLq3mUePnt3zOrs/vdUhMeDTl0vDzERlFUt6n1y7
'' SIG '' 4wJl69xKEgWfNzJIMpfSskcWm0mmPNNXZ7KeiEccYGaN
'' SIG '' Tcd8siIJEPqs5RNa/jn9kkh4bqZ3MWJ18SiZeDMA/S7J
'' SIG '' xKNJuqbK/jTJC9juB3ms0x+dyE0qDnMBY2nczBlH1u8B
'' SIG '' 17Kp5XqW3CAT7fT0A/mxbfkmVopZ6fWDG3Re4D07E+Hu
'' SIG '' 5+qKwYFb2W5IOdVMaPFqQtZONiWca4oX1Z9qvfJDTfPE
'' SIG '' 8PCiJ0ul8kcNA95GEK8DkF+iXM+JPsFuYqtSFCuYu8+F
'' SIG '' Qj7KKLLpzm4ZI3orP5gLfl8FTJfkFx1wBLR7uPst5aLi
'' SIG '' zIfrDI5uTZ8VO02d0r7uouflbsyOp0USkfKRlKngXDwK
'' SIG '' Es1mL9I/n7RUcjCf3cHuzZUELnV1mk91Ug2RzrFoIJ6K
'' SIG '' End signature block
